using System;
using Server;
using Server.Items;
using Server.Misc;

namespace Server.Mobiles
{
	//[CorpseName( "a black order mage corpse" )] 
	public class DragonsFlameMage : BaseCreature
	{	
		public override bool ClickTitle{ get{ return false; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		
      [Constructable]
		public DragonsFlameMage() : base( AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "black order mage";
			Title = "of the dragon's flame sect";
			Female = Utility.RandomBool();
			Race = Race.Human;
			Hue = Race.RandomSkinHue();
			HairItemID = Race.RandomHair( Female );
			HairHue = Race.RandomHairHue();
			Race.RandomFacialHair( this );
			
			AddItem( new NinjaTabi() );
			AddItem( new FancyShirt( 0x51D ) );
			AddItem( new Hakama( 0x51D ) );
			AddItem( new Kasa( 0x51D ) );
			
			SetStr( 96, 150 );
			SetDex( 50, 105 );
			SetInt( 231, 275 );
			SetHits( 302, 415 );
			
			SetDamage( 10, 33 );

			SetSkill( SkillName.MagicResist, 45.0, 77.5 );
			SetSkill( SkillName.Magery, 105.0, 120.5 );
			SetSkill( SkillName.Meditation, 75.0, 90.5 );
			SetSkill( SkillName.EvalInt, 105.0, 120.5 );
			SetSkill( SkillName.Wrestling, 75.0, 87.5 );
			SetSkill( SkillName.Tactics, 65.0, 70.5 );

			Fame = 8000;
			Karma = -9000;
			VirtualArmor = 26;
		}

		public DragonsFlameMage( Serial serial ) : base( serial )
		{
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.SeRich );
		}
		
		public override void AlterSpellDamageFrom( Mobile from, ref int damage )
		{
			if ( from != null )
				from.Damage( damage / 2, from );
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}
